;
;***********************
;    DEMO TIMER 8253   *
;     EXPERIMENT 0BH   *
;***********************

         CPU  "Z80.TBL"
         HOF  "INT8"

         ORG  2000H

CWD:     EQU  0BFH
CH0:     EQU  0BCH
CTRL:    EQU  0BBH
GATE:    EQU  0B8H
RST38H:  EQU  3FD6H
LED:     EQU  0BAH
SYSCAL:  EQU  10H
DELAY:   EQU  0FH
SEGM:    EQU  1
DIGIT:   EQU  2

         DI
         XOR  A
         LD   (COL),A
         LD   A,80H
         OUT  (CTRL),A
         LD   HL,INT
         LD   (RST38H),HL
         LD   A,00010111B
         OUT  (CWD),A
         LD   A,50H
         OUT  (CH0),A

         LD   D,1
         LD   A,1
         OUT  (GATE),A
         EI

LOOP:    LD   A,D
         OUT  (LED),A

         LD   A,DELAY
         LD   B,50H
         RST  SYSCAL

         RLC  D
         JR   LOOP
;
INT:     PUSH AF
         PUSH BC
         PUSH HL

         LD   A,0
         NOP
         NOP
         OUT  (SEGM),A

         LD   A,(COL)
         OUT  (DIGIT),A
         LD   C,A
         INC  A
         CP   6
         JR   NZ,INT1
         LD   A,0

INT1:    LD   (COL),A
         LD   B,0
;
         LD   HL,TABLE
         ADD  HL,BC
         LD   A,(HL)
         OUT  (SEGM),A
         LD   A,1
         OUT  (GATE),A

         POP  HL
         POP  BC
         POP  AF
         EI
         RET
;
TABLE:   DFB 3FH,06H,5BH,4FH,66H,6DH

         ORG   3000H
COL:     DFS   1

